# q1 solution for 2022 Iverson Exam

def steal(C, N, A, P):
    # create a list of pairs (p,a) of spices with price p and amount a
    spices = [(P[i], A[i]) for i in range(N)]

    # sort them and reverse the list so the most profitable spices are
    # at the start
    spices.sort()
    spices = spices[::-1]

    # the value we can obtain
    value = 0

    # the amount of space left in our bag
    remain = C

    for p, a in spices:
        # take all of this spice or as much space as we have left
        take = min(remain, a)

        remain -= take
        value += take*p

    return value

if __name__ == "__main__":
    # run the examples from the question description

    ex_val = steal(10, 4, [5, 7, 5, 1], [3, 4, 2, 2])
    print("Q1 Example:", ex_val)

    pi_val = steal(5, 2, [3, 3], [3, 4])
    print("Part 2.i:", pi_val)

    pii_val = steal(10, 4, [3, 3, 1, 2], [3, 4, 2, 2])
    print("Part 2.ii:", pii_val)

    piii_val = steal(5, 4, [3, 3, 1, 2], [1, 2, 4, 3])
    print("Part 2.iii:", piii_val)
