# q2 solution for 2022 Iverson Exam

def candles(age, fingers):
    digits = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"

    # this also works
    # import string
    # digits = string.digits + string.ascii_uppercase

    # get a list of candles
    ans = []

    # make sure you use an approved # of fingers!
    assert fingers in range(2, 37)

    while age > 0:
        ans.append(digits[age % fingers])
        age //= fingers

    # we built the array in reverse order, so reverse it again
    ans = ans[::-1]

    # special case: if they are 0 years old we haven't put anything here yet
    if ans == []: ans = ["0"]

    # return as a single string, not an array of candle digits
    return "".join(ans)

if __name__ == "__main__":
    ages = [43, 14, 68, 11, 1055, 4694]
    fingers = [11, 3, 35, 2, 16, 20]

    print("Examples from the table in Q2")
    for i in range(len(ages)):
        ans = candles(ages[i], fingers[i])
        print("age", ages[i], "fingers", fingers[i], " ==> candle representation", ans)
