# q3 part b solution for 2022 Iverson Exam
# note we said "print" instead of "return", but we were ok with either

# for full credit
def winner(n):
    return "Alice" if n%3 != 0 else "Bob"

# for partial credit, harder to implement but maybe easier to see
def winner_pc(n):
    # alice_wins[i] will be True if alice wins when beginning with a pile of
    # of size i, clearly alice_wins[0] is False (eg. see the problem description)
    alice_wins = [False]

    for k in range(1, n+1):
        can_win = False
        i = 0
        while 2**i <= k:
            if not alice_wins[k-2**i]:
                can_win = True
            i += 1
        alice_wins.append(can_win)

    return "Alice" if alice_wins[n] else "Bob"

if __name__ == "__main__":
    print("Part b, up to n = 20")

    for n in range(21):
        win1 = winner(n)
        win2 = winner_pc(n)

        assert win1 == win2 # make sure the function outputs agree, just as an extra check

        print("n =", n, ", winner = ", win1, ", winner_pc = ", win2)
