# q4 solution for 2022 Iverson exam

# full credit solution
def f(n):
    ones = 0
    while n > 0:
        ones += (n%2)
        n //= 2
    return ones%2

# partial credit solution
# might crash if you use a very large n since the list
# it constructs has length n
def f_pc(n):
    seq = [0]
    while len(seq) < n+1:
        seq = seq + [1-x for x in seq]
    return seq[n]

if __name__ == "__main__":
    print("a_n for n up to 15")
    print("Full credit solution:    ", end="")
    print(*[f(n) for n in range(16)], sep="")
    print("Partial credit solution: ", end="")
    print(*[f_pc(n) for n in range(16)], sep="")

    print()

    print("n = 2022")
    print("Full credit solution: f(n) =", f(2022))
    print("Partial credit solution: f(n) =", f_pc(2022))

    print()

    big_n = 192835982478192
    # don't run f_pc for big_n
    print("f({0}) =".format(big_n), f(big_n))
